/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework;

import com.google.common.collect.Maps;
import doggytalents.client.screen.framework.AbstractSlice;
import doggytalents.client.screen.framework.IStoreSubscriber;
import doggytalents.client.screen.framework.StoreConnectedScreen;
import doggytalents.client.screen.framework.UIAction;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;

public class Store {
    private static Store INSTANCE;
    private final Screen screen;
    private IStoreSubscriber subscriber;
    private final Map<Class<? extends AbstractSlice>, StoreValue> applicationStates = Maps.newHashMap();
    private final ArrayList<UIAction> dispatchedAction = new ArrayList();

    private Store(Screen screen) {
        this.screen = screen;
        this.registerSlices();
        this.init();
    }

    private <T extends AbstractSlice> void registerSlice(Class<T> slice) {
        try {
            AbstractSlice worker = (AbstractSlice)slice.getConstructor(new Class[0]).newInstance(new Object[0]);
            StoreValue storeValue = new StoreValue(worker, worker.getInitalState());
            this.applicationStates.computeIfAbsent(slice, $ -> storeValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerSlices() {
        if (!(this.screen instanceof StoreConnectedScreen)) {
            return;
        }
        StoreConnectedScreen storeScr = (StoreConnectedScreen)this.screen;
        for (Class<? extends AbstractSlice> slice : storeScr.getSlices()) {
            this.registerSlice(slice);
        }
    }

    private void init() {
        for (Map.Entry<Class<? extends AbstractSlice>, StoreValue> x : this.applicationStates.entrySet()) {
            Object initState;
            x.getValue().state = initState = x.getValue().worker.getInitalState();
        }
    }

    public <T extends AbstractSlice> void dispatch(Class<T> slice, UIAction action) {
        action.targetSlice = slice;
        this.dispatchedAction.add(action);
    }

    public <T extends AbstractSlice> void dispatchAll(UIAction action) {
        action.targetSlice = null;
        this.dispatchedAction.add(action);
    }

    public void update() {
        if (this.dispatchedAction.isEmpty()) {
            return;
        }
        ArrayList<Class<? extends AbstractSlice>> changedSlices = new ArrayList<Class<? extends AbstractSlice>>();
        for (UIAction action : this.dispatchedAction) {
            this.processUIAction(action, changedSlices);
        }
        this.dispatchedAction.clear();
        if (!changedSlices.isEmpty()) {
            this.subscriber.onStoreUpdated(changedSlices);
        }
    }

    private void processUIAction(UIAction action, ArrayList<Class<? extends AbstractSlice>> changedSlices) {
        Class<? extends AbstractSlice> targetSlice = action.targetSlice;
        if (targetSlice == null) {
            for (Map.Entry<Class<? extends AbstractSlice>, StoreValue> entry : this.applicationStates.entrySet()) {
                StoreValue storeValue = entry.getValue();
                if (storeValue == null) {
                    return;
                }
                Object oldState = storeValue.state;
                storeValue.state = storeValue.worker.reducer(storeValue.state, action);
                if (oldState == storeValue.state) continue;
                changedSlices.add(entry.getKey());
            }
            return;
        }
        StoreValue storeValue = this.applicationStates.get(targetSlice);
        if (storeValue == null) {
            return;
        }
        Object oldState = storeValue.state;
        storeValue.state = storeValue.worker.reducer(storeValue.state, action);
        if (oldState != storeValue.state) {
            changedSlices.add(targetSlice);
        }
    }

    public <T, S extends AbstractSlice> T getStateOrDefault(Class<S> slice, Class<T> cast, T defaultState) {
        StoreValue storeValue = this.applicationStates.get(slice);
        if (storeValue == null) {
            return defaultState;
        }
        if (cast.isInstance(storeValue.state)) {
            return cast.cast(storeValue.state);
        }
        return defaultState;
    }

    public static Store get(Screen screen) {
        if (INSTANCE == null) {
            INSTANCE = new Store(screen);
            if (screen instanceof IStoreSubscriber) {
                IStoreSubscriber sub;
                Store.INSTANCE.subscriber = sub = (IStoreSubscriber)screen;
            }
        } else if (screen != Store.INSTANCE.screen) {
            INSTANCE = new Store(screen);
            if (screen instanceof IStoreSubscriber) {
                IStoreSubscriber sub;
                Store.INSTANCE.subscriber = sub = (IStoreSubscriber)screen;
            }
        }
        return INSTANCE;
    }

    public static void finish() {
        INSTANCE = null;
    }

    private static class StoreValue {
        public AbstractSlice worker;
        public Object state;

        public StoreValue(AbstractSlice worker, Object state) {
            this.worker = worker;
            this.state = state;
        }
    }
}

